/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.Trace;
import java.net.Socket;

public class PIHscProviderSocket
extends Socket {
    private boolean m_validStatus = true;
    private boolean m_busy = false;
    private Thread m_lockThread = null;
    private String m_cecName = null;
    private String m_spVersion = null;
    private long m_maxCommandSize = -1L;
    private int m_maxBroadcastSize = -1;
    private int m_vport = -1;

    public PIHscProviderSocket(String string, int n) throws Exception {
        super(string, n);
    }

    public String getCecName() {
        return this.m_cecName;
    }

    public void setCecName(String string) {
        this.m_cecName = string;
    }

    public String getSPVersion() {
        return this.m_spVersion;
    }

    public void setSPVersion(String string) {
        this.m_spVersion = string;
    }

    public int getVport() {
        return this.m_vport;
    }

    public void setVport(int n) {
        this.m_vport = n;
    }

    public int getMaxBroadcastSize() {
        return this.m_maxBroadcastSize;
    }

    public void setMaxBroadcastSize(int n) {
        this.m_maxBroadcastSize = n;
    }

    public long getMaxCommandSize() {
        return this.m_maxCommandSize;
    }

    public void setMaxCommandSize(long l) {
        this.m_maxCommandSize = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean lock() {
        Object object;
        if (Trace.LEVEL >= 3) {
            object = "Thread " + Thread.currentThread().getName() + "In Lock";
            Trace.trace("apcshscD", "ProviderSocket", object);
        }
        while (this.m_busy && this.m_validStatus) {
            object = this;
            synchronized (object) {
                String string = " => Request Thread: [" + Thread.currentThread().getName() + "], Lock Thread: [" + this.m_lockThread + "]";
                Trace.trace("apcshscT", "ProviderSocket", string);
                try {
                    this.wait(10000L);
                }
                catch (Exception exception) {
                    HSCLogUtils.serverLog(exception, HSCLogUtils._HSCClassLogInfo);
                }
            }
        }
        this.m_busy = true;
        if (this.m_validStatus) {
            this.m_lockThread = Thread.currentThread();
            Trace.trace("apcshscT", "ProviderSocket", " => " + this.m_lockThread.getName() + " get lock");
            return true;
        }
        this.m_busy = false;
        return false;
    }

    public synchronized void releaseLock() {
        if (Trace.LEVEL >= 3) {
            String string = "In releaselock\nLock released by " + Thread.currentThread().getName();
            Trace.trace("apcshscD", "ProviderSocket", string);
        }
        Trace.trace("apcshscT", "ProviderSocket", " => LockThread[" + this.m_lockThread + "], releaselock Thread[" + Thread.currentThread().getName() + "]");
        this.m_lockThread = null;
        this.m_busy = false;
        this.notifyAll();
    }

    public void closeSocket() throws Exception {
        this.m_lockThread = null;
        this.m_busy = false;
        this.m_validStatus = false;
        this.close();
    }
}

